<?php
/**
 * Plugin Name: Halink Hub Install
 * Plugin URI: https://halink.vn
 * Description: Tự động cài halink hub vào website
 * Version: 1.0
 * Author: Halink
 * Author URI: https://halink.vn
 * License: GPLv2
 */
define("init_core_url", "https://hub.halink.vn/api/v1/install");

function halink_hub_activation_redirect( $plugin ) {
    if( $plugin == plugin_basename( __FILE__ ) ) {
        exit( wp_redirect( admin_url( '/admin.php?page=halink-hub' ) ) );
    }
}
add_action( 'activated_plugin', 'halink_hub_activation_redirect' );

add_action( 'wp_ajax_halink_hub_check', 'halink_hub_check' );
add_action( 'wp_ajax_nopriv_halink_hub_check', 'halink_hub_check' );
function halink_hub_check() {
    if(file_exists(get_template_directory()."/halink-hub/core.php")){
        wp_send_json_success();
    }
    wp_send_json_error();
    
 
    die();//bắt buộc phải có khi kết thúc
}

add_action( 'wp_ajax_halink_hub_create', 'halink_hub_create' );
add_action( 'wp_ajax_nopriv_halink_hub_create', 'halink_hub_create' );
function halink_hub_create() {
    mkdir(get_template_directory()."/halink-hub");
    wp_send_json_success("Khởi tạo Hub");
    die();//bắt buộc phải có khi kết thúc
}

add_action( 'wp_ajax_halink_hub_register', 'halink_hub_register' );
add_action( 'wp_ajax_nopriv_halink_hub_register', 'halink_hub_register' );
function halink_hub_register() {
    $urlparts = parse_url(home_url());
    $domain = $urlparts['host'];
    $fields = ["domain"=>$domain, "theme"=>wp_get_theme()->stylesheet];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, init_core_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    $resp = curl_exec($ch);
    curl_close($ch);
    $download_core = json_decode($resp);
    $download_core_url = $download_core->url;
    $core_path = get_template_directory()."/halink-hub";

    file_put_contents("{$core_path}/hub.core.php", "<?php\nglobal \$client_id;\n\$client_id = '{$download_core->id}';");

    if(!file_exists("{$core_path}/tmp")){
        mkdir("{$core_path}/tmp");
    }
    file_put_contents("{$core_path}/tmp/core.zip", file_get_contents($download_core_url));
    $zip = new ZipArchive;
    if ($zip->open("{$core_path}/tmp/core.zip") === TRUE) {
        $zip->extractTo($core_path);
        $zip->close();
        if(file_exists("{$core_path}/tmp/core.zip"))
            unlink("{$core_path}/tmp/core.zip");
    }
    $function_content = file_get_contents(get_template_directory()."/functions.php");
    $function_content = str_replace("require_once(get_template_directory().'/halink-hub/core.php');", "", $function_content);
    $function_content = "<?php\n\trequire_once(get_template_directory().'/halink-hub/core.php');\n?>\n".$function_content;
    // var_dump($function_content);
    // $function_content = preg_replace('/<\?\php/', "<?php\ndefine( 'HNP', get_template_directory() . '/hnp' );\nrequire_once( HNP . '/init.php' );", $function_content, 1);
    // var_dump($function_content);

    file_put_contents(get_template_directory()."/functions.php", $function_content);
    wp_send_json_success("Đăng ký Hub với máy chủ");
 
    die();//bắt buộc phải có khi kết thúc
}

add_action('admin_menu', 'halink_hub_menu');

function halink_hub_menu() {
    add_menu_page( 'Halink Hub Install', 'Halink Hub', 'manage_options', 'halink-hub', 'vcn_customers_list', null, 6 );
}


function vcn_customers_list(){
?>
<div id="hnp">
<template>
<div style="margin: 10px 20px 0 2px;">
    <h1>Halink Hub Install</h1>
    <div style=" width: 100%; background: #fff; margin: 16px 0; padding: 23px 10px;">
        <p v-if="!isLoading && !success" style="text-align: center; font-size: 18px;"> Click vào <strong>Start</strong> để tiến hành cài đặt Hub vào website.</p>
        <div v-if="isLoading" style="text-align: center;">
        <img style="width: 80px; margin: auto;" src="<?=plugin_dir_url( __FILE__ ).'assets/images/loading.gif'?>" />
        </div>
        <ul v-if="!success" style="width: 300px; margin: auto;margin-bottom: 20px; font-size: 18px;">
        <li v-for="(step, index) in steps" v-bind:key="'step-'+index"><span class="dashicons dashicons-yes-alt"></span> {{step}}</li>
        </ul>
        <p v-if="success" style="text-align: center; font-size: 18px;"><span style="padding: .75rem 1.25rem;  margin-bottom: 1rem; border: 1px solid transparent; border-radius: .25rem;  color: #155724;  background-color: #d4edda; border-color: #c3e6cb;">Đã cài đặt thành công Hub. Vui lòng gỡ plugin Halink Hub Install khỏi website này.</span></p>
        <div v-if="!isLoading && !success"  style="text-align: center;"><button @click.prevent="install" class="button button-primary" style=" font-size: 18px; padding: 0px 20px;">Start</button></div>
    </div>
</div>
</template>
</div>
<script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
<script src="https://unpkg.com/axios/dist/axios.min.js"></script>

<script>
var app = new Vue({
  el: '#hnp',
  data: {
    isLoading: false,
    success: false,
    steps: []
  },
  created(){
    const hnp = this;
    let formData = new FormData;
        
    formData.append("action", "halink_hub_check");
    return axios.post("<?php echo admin_url('admin-ajax.php');?>", formData)
        .then(function (resp) {
            hnp.success = resp.data.success;
               
        })
        .catch(function (error) {
        });
  },
  methods: {
    async install(){
        const hnp = this;
        hnp.isLoading = true;
        let step1 = await hnp.createHub();
        let step2 = await hnp.registerHub();
        hnp.isLoading = false;
        hnp.success = true;
    },
    createHub(){
        const hnp = this;
        let formData = new FormData;
        
        formData.append("action", "halink_hub_create");
        return axios.post("<?php echo admin_url('admin-ajax.php');?>", formData)
            .then(function (resp) {
                hnp.steps.push(resp.data.data);
               
            })
            .catch(function (error) {
                console.log(error);
            });
        return true;
    },
    registerHub(){
        const hnp = this;
        let formData = new FormData;
        formData.append("action", "halink_hub_register");
        return axios.post("<?php echo admin_url('admin-ajax.php');?>", formData)
            .then(function (resp) {
                hnp.steps.push(resp.data.data);
               
            })
            .catch(function (error) {
                console.log(error);
            });
            return true;
    }

  }
});
</script>


<?php
}
